#pragma once

#include <vector>
#include "SkinManager.h"
#include "SkinScrollBar.h"

class CLVColumn
{
public:
	CLVColumn(void);
	~CLVColumn(void);

public:
	CString m_strText;
	CImageEx * m_lpImage;
	DWORD m_dwFmt;
	int m_nWidth;
};

class CLVItem
{
public:
	CLVItem(void);
	~CLVItem(void);

public:
	CString m_strText;
	Gdiplus::Bitmap * m_lpImage;
	DWORD m_dwFmt;
	LPARAM m_lParam;
};

class CLVRow
{
public:
	CLVRow(int nCols);
	~CLVRow(void);

public:
	BOOL AddItem();
	BOOL InsertItem(int nCol);
	BOOL DeleteItem(int nCol);

	BOOL SetItem(int nCol, LPCTSTR lpszText, LPCTSTR lpszImage, 
		int cx, int cy, BOOL bGray, DWORD dwFmt, LPARAM lParam);

	BOOL SetItemText(int nCol,  LPCTSTR lpszText);
	BOOL SetItemImage(int nCol,  LPCTSTR lpszImage, int cx, int cy, BOOL bGray = FALSE);
	BOOL SetItemFormat(int nCol,  DWORD dwFmt);
	BOOL SetItemData(int nCol,  LPARAM lParam);

	CString GetItemText(int nCol);
	Gdiplus::Bitmap * GetItemImage(int nCol);
	DWORD GetItemFormat(int nCol);
	LPARAM GetItemData(int nCol);

	int GetItemCount();
	BOOL DeleteAllItems();

private:
	CLVItem * GetItem(int nCol);

private:
	std::vector<CLVItem *> m_arrItems;
};

class CSkinListCtrl : public CWindowImpl<CSkinListCtrl, CWindow>
{
public:
	CSkinListCtrl(void);
	~CSkinListCtrl(void);

	BEGIN_MSG_MAP_EX(CSkinListCtrl)
		MSG_WM_CREATE(OnCreate)
		MSG_WM_ERASEBKGND(OnEraseBkgnd)
		MSG_WM_PAINT(OnPaint)
		MSG_WM_LBUTTONDBLCLK(OnLButtonDblClk)
		MSG_WM_LBUTTONDOWN(OnLButtonDown)
		MSG_WM_LBUTTONUP(OnLButtonUp)
		MSG_WM_RBUTTONDOWN(OnRButtonDown)
		MSG_WM_MOUSEMOVE(OnMouseMove)
		MSG_WM_MOUSELEAVE(OnMouseLeave)
		MSG_WM_TIMER(OnTimer)
		MSG_WM_HSCROLL(OnHScroll)
		MSG_WM_VSCROLL(OnVScroll)
		MSG_WM_MOUSEWHEEL(OnMouseWheel)
		MSG_WM_KEYDOWN(OnKeyDown)
		MSG_WM_SIZE(OnSize)
		MSG_WM_GETDLGCODE(OnGetDlgCode)
		//MESSAGE_RANGE_HANDLER_EX(WM_MOUSEFIRST, WM_MOUSELAST, OnMouseMessage)
		MSG_WM_DESTROY(OnDestroy)
	END_MSG_MAP()

public:
	BOOL SetBgPic(LPCTSTR lpszFileName);				// бͼƬ
	BOOL SetHeadSeparatedPic(LPCTSTR lpszFileName);		// ñͷָͼƬ

	BOOL SetHeadNormalPic(LPCTSTR lpszFileName);		// ñͷͼƬ(ͨ״̬)
	BOOL SetHeadHotPic(LPCTSTR lpszFileName);			// ñͷͼƬ(״̬)
	BOOL SetHeadPushedPic(LPCTSTR lpszFileName);		// ñͷͼƬ(״̬)

	BOOL SetOddItemBgPic(LPCTSTR lpszFileName);			// бͼƬ(ͨ״̬)
	BOOL SetEvenItemBgPic(LPCTSTR lpszFileName);		// ˫бͼƬ(ͨ״̬)
	BOOL SetItemHotBgPic(LPCTSTR lpszFileName);			// бͼƬ(״̬)
	BOOL SetItemSelBgPic(LPCTSTR lpszFileName);			// бͼƬ(ѡ״̬)

	void SetTransparent(BOOL bTransparent, HDC hBgDC);	// бǷ͸
	void SetHeadVisible(BOOL bVisible);					// ñͷǷɼ
	BOOL IsHeadVisible();								// жϱͷǷɼ
	void SetHeadHeight(int nHeight);					// ñͷ߶
	void SetItemHeight(int nHeight);					// и߶
	void SetItemImageSize(int cx, int cy);				// ͼС

	int AddColumn(LPCTSTR lpszText,						// 
		LPCTSTR lpszImage, DWORD dwFmt, int nWidth);
	int InsertColumn(int nCol, LPCTSTR lpszText,		// 
		LPCTSTR lpszImage, DWORD dwFmt, int nWidth);
	BOOL DeleteColumn(int nCol);						// ɾ

	int AddItem(LPCTSTR lpszText,						// 
		LPCTSTR lpszImage, BOOL bGray, DWORD dwFmt, LPARAM lParam);
	int InsertItem(int nItem, LPCTSTR lpszText,			// 
		LPCTSTR lpszImage, BOOL bGray, DWORD dwFmt, LPARAM lParam);
	BOOL DeleteItem(int nItem);							// ɾ

	int GetColumnCount();								// ȡ
	BOOL DeleteAllColumns();							// ɾ
	int GetItemCount();									// ȡ
	BOOL DeleteAllItems();								// ɾ

	BOOL SetColumnText(int nCol, LPCTSTR lpszText);		// ı
	BOOL SetColumnImage(int nCol, LPCTSTR lpszImage);	// ͼ
	BOOL SetColumnFormat(int nCol, DWORD dwFmt);		// иʽ
	BOOL SetColumnWidth(int nCol, int nWidth);			// п

	CString GetColumnText(int nCol);					// ȡı
	DWORD GetColumnFormat(int nCol);					// ȡиʽ
	int GetColumnWidth(int nCol);						// ȡп

	BOOL SetItemText(int nItem, int nSubItem, LPCTSTR lpszText);	// ı
	BOOL SetItemImage(int nItem, int nSubItem,						// ͼ
		LPCTSTR lpszImage, BOOL bGray = FALSE);
	BOOL SetItemFormat(int nItem, int nSubItem, DWORD dwFmt);		// иʽ
	BOOL SetItemData(int nItem, int nSubItem, LPARAM lParam);		// 

	CString GetItemText(int nItem, int nSubItem);		// ȡı
	DWORD GetItemFormat(int nItem, int nSubItem);		// ȡиʽ
	LPARAM GetItemData(int nItem, int nSubItem);		// ȡ

	int GetCurSelItemIndex();							// ȡǰѡ
	void SetItemTextColor(COLORREF clr);				// ıɫ(ͨ״̬)
	void SetSelItemTextColor(COLORREF clr);				// ıɫ(ѡ״̬)

private:
	int OnCreate(LPCREATESTRUCT lpCreateStruct);
	BOOL OnEraseBkgnd(CDCHandle dc);
	void OnPaint(CDCHandle dc);
	void OnLButtonDblClk(UINT nFlags, CPoint point);
	void OnLButtonDown(UINT nFlags, CPoint point);
	void OnLButtonUp(UINT nFlags, CPoint point);
	void OnRButtonDown(UINT nFlags, CPoint point);
	void OnMouseMove(UINT nFlags, CPoint point);
	void OnMouseLeave();
	void OnTimer(UINT_PTR nIDEvent);
	void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar pScrollBar);
	void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar pScrollBar);
	BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	void OnSize(UINT nType, CSize size);
	UINT OnGetDlgCode(LPMSG lpMsg);
	//LRESULT OnMouseMessage(UINT uMsg, WPARAM wParam, LPARAM lParam);
	void OnDestroy();

	CLVColumn * GetColumn(int nCol);
	CLVRow * GetItem(int nItem);

	void DrawParentWndBg(HDC hDC);
	void DrawHeadPart(HDC hDC);
	void DrawItemPart(HDC hDC);

	BOOL GetHeadPartRect(CRect& rect);
	BOOL GetItemPartRect(CRect& rect);
	BOOL GetItemRect(int nIndex, CRect& rect);
	int HeadHitTest(POINT pt);
	int ItemHitTest(POINT pt);
	BOOL StartTrackMouseLeave();
	void AdjustScrollBarSize();
	void CheckScrollBarStatus();
	void Scroll(int cx, int cy);
	void EnsureVisible(int nIndex);
	int GetColumnsWidth();

	BOOL Init();
	void UnInit();

private:
	//CToolTipCtrl m_ToolTipCtrl;
	CSkinScrollBar m_HScrollBar;
	CSkinScrollBar m_VScrollBar;

	std::vector<CLVColumn *> m_arrCols;
	std::vector<CLVRow *> m_arrRows;

	CImageEx * m_lpBgImg;					// бͼƬ
	CImageEx * m_lpHeadSeparatedImg;		// ͷָͼƬ
	CImageEx * m_lpHeadImgN;				// ͷͼƬ(ͨ״̬)
	CImageEx * m_lpHeadImgH;				// ͷͼƬ(״̬)
	CImageEx * m_lpHeadImgP;				// ͷͼƬ(״̬)
	CImageEx * m_lpOddItemBgImgN;			// бͼƬ(ͨ״̬)
	CImageEx * m_lpEvenItemBgImgN;			// ˫бͼƬ(ͨ״̬)
	CImageEx * m_lpItemBgImgH;				// бͼƬ(״̬)
	CImageEx * m_lpItemBgImgS;				// бͼƬ(ѡ״̬)

	BOOL m_bTransparent;					// бǷ͸־
	HDC m_hBgDC;							// ڱDC
	BOOL m_bMouseTracking;					// ٱ־
	BOOL m_bHeadVisible;					// ͷǷɼ־
	int m_nHeadHeight;						// ͷ߶
	int m_nItemHeight;						// и߶
	CSize m_szItemImage;					// ͼС

	int m_nPressHeadIndex;					// 갴±ͷ
	int m_nHoverHeadIndex;					// ͣͷ

	int m_nPressItemIndex;					// 갴
	int m_nHoverItemIndex;					// ͣ
	int m_nSelItemIndex;					// ѡ

	int m_nLeft, m_nTop;					// ͼԭ

	COLORREF m_clrItemText;					// ıɫ(ͨ״̬)
	COLORREF m_clrSelItemText;				// ıɫ(ѡ״̬)
};
